<?php

/**
 * DokuWiki Mikio Template English Language File
 *
 * @link    http://dokuwiki.org/template:mikio
 * @author  James Collins <james.collins@outlook.com.au>
 * @license GPLv2 (http://www.gnu.org/licenses/gpl-2.0.html)
 */

 /* Theme */
$lang['sidebar-title']  = 'Sidebar';
$lang['tools-menu']     = 'Tools';
$lang['home']           = 'Home';


/* Config */
$lang['config_navbar']      = 'Menubar';
$lang['config_search']      = 'Search';
$lang['config_hero']        = 'Hero';
$lang['config_tags']        = 'Tags';
$lang['config_breadcrumb']  = 'Breadcrumb';
$lang['config_youarehere']  = 'You Are Here';
$lang['config_sidebar']     = 'Sidebars';
$lang['config_toc']         = 'Table of Contents';
$lang['config_pagetools']   = 'Page Tools';
$lang['config_footer']      = 'Footer';
$lang['config_license']     = 'License';
$lang['config_acl']         = 'Permissions';
$lang['config_sticky']      = 'Sticky Parts';


/* Setting Values */
$lang['value_never']        = 'never';
$lang['value_admin']        = 'admin';
$lang['value_always']       = 'always';
$lang['value_icons']        = 'icons';
$lang['value_text']         = 'text';
$lang['value_both']         = 'both';
$lang['value_separate']     = 'separate';
$lang['value_dropdown']     = 'dropdown';
$lang['value_combine']      = 'combine';
$lang['value_none']         = 'none';
$lang['value_custom']       = 'custom';
$lang['value_search']       = 'search';
$lang['value_dokuwiki']     = 'dokuwiki';
$lang['value_logged_in']    = 'logged in';
$lang['value_logged_out']   = 'logged out';
$lang['value_icon']         = 'icon';
$lang['value_top']          = 'top';
$lang['value_hero']         = 'hero';
$lang['value_page']         = 'page';
$lang['value_page_title']   = 'page title';
$lang['value_home']         = 'home';
$lang['value_logged_in_user'] = 'logged in user';
$lang['value_content']      = 'content';
$lang['value_tags']         = 'tags';
$lang['value_page_editors'] = 'page editors';
$lang['value_badge']        = 'badge';
$lang['value_button']       = 'button';





/* Style.ini */
$lang['__link__']       = 'The font color of links';
$lang['__link_hover__'] = 'The font color of links when cursor hovers over';
$lang['__link_visited__'] = 'The font color of links when previously visited';
$lang['__link_active__'] = 'The font color of links the moment it is clicked';
$lang['__existing__']   = 'The font color of wiki links for existing pages';
$lang['__existing_hover__']   = 'The font color of wiki links for existing pages when cursor hovers over';
$lang['__existing_visited__']   = 'The font color of wiki links for existing pages when previously visited';
$lang['__existing_active__']   = 'The font color of wiki links for existing pages the moment it is clicked';
$lang['__missing__']    = 'The font color of wiki links for missing pages';
$lang['__missing_hover__']    = 'The font color of wiki links for missing pages when cursor hovers over';
$lang['__missing_visited__']    = 'The font color of wiki links for missing pages when previously visited';
$lang['__missing_active__']    = 'The font color of wiki links for missing pages the moment it is clicked';
$lang['__line_height__']    = 'The base font line height';
$lang['__site_width__']     = 'Width of the body content';

$lang['__font_size__']              = 'The base font size';
$lang['__font_family__']            = 'The base font family (fonts containing spaces must be in quotes. Multiple fonts
can be seperated with commas)';
$lang['__admin_background_color__'] = 'Background color of admin pages';

$lang['__code_font_family__']       = 'The font family for code blocks (fonts containing spaces must be in quotes.
Multiple fonts can be seperated with commas)';
$lang['__code_font_size__']         = 'The font size for code blocks';
$lang['__code_text_color__']        = 'The font color for code blocks';
$lang['__code_background_color__']  = 'The background color for code blocks';
$lang['__code_line_height__']       = 'The font line height for code blocks';
$lang['__code_word_wrap__']         = 'The word wrap style for code blocks';
$lang['__code_border_color__']      = 'The border color for code blocks';

$lang['__control_text_color__']                     = 'The font color for controls';
$lang['__control_border_color__']                   = 'The border color for controls';
$lang['__control_background_color__']               = 'The background color for controls';
$lang['__button_text_color__']                      = 'The font color for buttons';
$lang['__button_background_color__']                = 'The background color for buttons';
$lang['__button_border_color__']                    = 'The border color for buttons';
$lang['__button_text_hover_color__']                = 'The font color for buttons when cursor hovers over';
$lang['__button_background_hover_color__']          = 'The background color for buttons when cursor hovers over';
$lang['__button_border_hover_color__']              = 'The border color for buttons when cursor hovers over';
$lang['__input_text_color__']                       = 'The text color for input fields';
$lang['__input_border_color__']                     = 'The border color for input fields';
$lang['__input_background_color__']                 = 'The background color for input fields';
$lang['__button_default_text_color__']              = 'The font color for the default button';
$lang['__button_default_background_color__']        = 'The background color for the default button';
$lang['__button_default_border_color__']            = 'The border color for the default button';
$lang['__button_default_text_hover_color__']        = 'The font color for the default button when cursor hovers over';
$lang['__button_default_background_hover_color__']  = 'The background color for the default button when cursor hovers
over';
$lang['__button_default_border_hover_color__']      = 'The border color for the default button when cursor hovers over';
$lang['__button_search_text_color__']               = 'The font color for the search button';
$lang['__button_search_background_color__']         = 'The background color for the search button';
$lang['__button_search_border_color__']             = 'The border color for the search button';
$lang['__button_search_text_hover_color__']         = 'The font color for the search button when cursor hovers over';
$lang['__button_search_background_hover_color__']   = 'The background color for the search button when cursor hovers
over';
$lang['__button_search_border_hover_color__']       = 'The border color for the search button when cursor hovers over';

$lang['__topheader_background_color__'] = 'The background color for the top header part';
$lang['__header_background_color__']    = 'The background color for the header part';

$lang['__navbar_background_color__']    = 'The background color for the menu';
$lang['__navbar_border_color__']        = 'The border color for the menu';
$lang['__navbar_brand_text_color__']    = 'The font color for the site title';
$lang['__navbar_brand_tagline_color__'] = 'The font color for the site tagline';
$lang['__navbar_content_justify__']     = 'The content justification of the site menu (can be flex-start, flex-end,
center, space-between or space-around)';
$lang['__navbar_link_color__']          = 'The font color for the navbar links';
$lang['__navbar_link_hover_color__']    = 'The font color for the navbar links when cursor hovers over';
$lang['__navbar_search_max_width__']    = 'The maximum width of the search bar';

$lang['__subnavbar_text_color__']       = 'The font color for sub menu text';
$lang['__subnavbar_link_color__']       = 'The font color for sub menu links';
$lang['__subnavbar_link_hover_color__'] = 'The font color when the cursor hovers over sub menu links';
$lang['__subnavbar_background_color__'] = 'The background color for the sub menu';
$lang['__subnavbar_border_color__']     = 'The border color for the sub menu';
$lang['__subnavbar_content_justify__']  = 'The content justification of the sub menu (can be flex-start, flex-end,
center, space-between or space-around)';

$lang['__tag_background_color__']   = 'The background color of tags';
$lang['__tag_text_color__']         = 'The font color of tags ';

$lang['__breadcrumb_background_color__']    = 'The background color for the breadcrumb block';
$lang['__breadcrumb_font_size__']           = 'The font size for the breadcrumb block';
$lang['__breadcrumb_text_color__']          = 'The font color for breadcrumb text';
$lang['__breadcrumb_link_color__']          = 'The font color for breadcrumb links';
$lang['__breadcrumb_link_hover_color__']    = 'The font color when the cursor hovers over breadcrumb links';

$lang['__hero_title_color__']       = 'The font color for the hero title';
$lang['__hero_subtitle_color__']    = 'The font color for the hero sub title';
$lang['__hero_background_color__']  = 'The background color for the hero block';

$lang['__sidebar_width__']              = 'The sidebar width';
$lang['__sidebar_font_size__']          = 'The font size in sidebars';
$lang['__sidebar_text_color__']         = 'The font color for sidebars';
$lang['__sidebar_link_color__']         = 'The font color for links in sidebars';
$lang['__sidebar_link_hover_color__']   = 'The font color when the cursor hovers over links in sidebars';
$lang['__sidebar_background_color__']   = 'The background color for sidebars';
$lang['__sidebar_border_color__']       = 'The border color for sidebars';

$lang['__content_background__'] = 'The background color for page content';

$lang['__toc_background_color__']   = 'The background color for the TOC';
$lang['__toc_border_color__']       = 'The border color for the TOC';
$lang['__toc_font_size__']          = 'The font size for the TOC';
$lang['__toc_link_color__']         = 'The font color for TOC links';
$lang['__toc_link_hover_color__']   = 'The font color when the cursor hovers over TOC links';

$lang['__pagetools_color__']        = 'The color of page tool icons';
$lang['__pagetools_hover_color__']  = 'The color of page tools icons when cursor hovers';

$lang['__footer_font_size__']           = 'The font size for the footer';
$lang['__footer_text_color__']          = 'The font color for the footer';
$lang['__footer_link_color__']          = 'The font color for the footer links';
$lang['__footer_link_hover_color__']    = 'The font color when cursor hovers over footer links';
$lang['__footer_text_align__']          = 'The text alignment for the footer (can be left, center, right or justify)';
$lang['__footer_background_color__']    = 'The background color for the footer';

$lang['__table_font_size__']                    = 'The font size for tables';
$lang['__table_row_border_color__']             = 'The row border color for tables';
$lang['__table_col_border_color__']             = 'The column border color for tables';
$lang['__table_header_row_background_color__']  = 'The background color for table heading rows';
$lang['__table_header_row_text_color__']        = 'The font color for table heading rows';
$lang['__table_odd_row_text_color__']           = 'The font color for table odd rows';
$lang['__table_odd_row_background_color__']     = 'The background color for table odd rows';
$lang['__table_even_row_text_color__']          = 'The font color for table even rows';
$lang['__table_even_row_background_color__']    = 'The background color for table even rows';
$lang['__table_horizontal_padding__']           = 'The horizontal padding for table cells';
$lang['__table_vertical_padding__']             = 'The vertical padding for table cells';

$lang['__dropdown_color__']             = 'The font color for dropdown menus';
$lang['__dropdown_hover_color__']       = 'The font color when the cursor hovers over dropdown menu items';
$lang['__dropdown_border_color__']      = 'The border color for dropdown menus';
$lang['__dropdown_background_color__']  = 'The background color for dropdown menus';

$lang['__section_edit_highlight__']     = 'The color when highlighting an edit area';

$lang['__tree_background_color__']  = 'The background color of the tree view';
$lang['__tree_border_color__']      = 'The border color of the tree view';

$lang['__tab_color__']                      = 'The font color of a tab';
$lang['__tab_background_color__']           = 'The background color of a tab';
$lang['__tab_border_color__']               = 'The border color of a tab';
$lang['__tab_hover_color__']                = 'The font color of a tab when cursor hovers over';
$lang['__tab_background_hover_color__']     = 'The background color of a tab when cursor hovers over';
$lang['__tab_border_hover_color__']         = 'The border color of a tab when cursor hovers over';
$lang['__tab_active_color__']               = 'The font color of an active tab';
$lang['__tab_active_background_color__']    = 'The background color of an active tab';
$lang['__tab_active_border_color__']        = 'The border color of an active tab';

$lang['__footnote_popup_font_size__']           = 'The font size of the footnote popup';
$lang['__footnote_popup_text_color__']          = 'The font color of the footnote popup';
$lang['__footnote_popup_border_color__']        = 'The border color of the footnote popup';
$lang['__footnote_popup_background_color__']    = 'The background color of the footnote popup';
$lang['__footnote_popup_horizontal_padding__']  = 'The horizontal padding of the footnote popup';
$lang['__footnote_popup_vertical_padding__']    = 'The vertical padding of the footnote popup';

/* Plugin */
$lang['__plugin_background_color__']        = 'The background color used on Mikio Plugin elements';
$lang['__plugin_border_color__']            = 'The border color used on Mikio Plugin elements';
$lang['__plugin_header_background_color__'] = 'The background color used on header items within Mikio Plugin elements';
$lang['__plugin_footer_background_color__'] = 'The background color used on footer items within Mikio Plugin elements';

$lang['__plugin_primary_text_color__']              = 'Primary style font color';
$lang['__plugin_primary_text_hover_color__']        = 'Primary style font color when cursor hovers over';
$lang['__plugin_primary_background_color__']        = 'Primary style background color';
$lang['__plugin_primary_background_hover_color__']  = 'Primary style background color when cursor hovers over';
$lang['__plugin_primary_border_color__']            = 'Primary style border color';
$lang['__plugin_primary_border_hover_color__']      = 'Primary style border color when cursor hovers over';
$lang['__plugin_primary_light_text_color__']        = 'Primary style font color for light box items';
$lang['__plugin_primary_light_background_color__']  = 'Primary style background color for light box items';
$lang['__plugin_primary_light_border_color__']      = 'Primary style border color for light box items';

$lang['__plugin_secondary_text_color__']                = 'Secondary style font color';
$lang['__plugin_secondary_text_hover_color__']          = 'Secondary style font color when cursor hovers over';
$lang['__plugin_secondary_background_color__']          = 'Secondary style background color';
$lang['__plugin_secondary_background_hover_color__']  = 'Secondary style background color when cursor hovers over';
$lang['__plugin_secondary_border_color__']              = 'Secondary style border color';
$lang['__plugin_secondary_border_hover_color__']        = 'Secondary style border color when cursor hovers over';
$lang['__plugin_secondary_light_text_color__']          = 'Secondary style font color for light box items';
$lang['__plugin_secondary_light_background_color__']  = 'Secondary style background color for light box items';
$lang['__plugin_secondary_light_border_color__']        = 'Secondary style border color for light box items';

$lang['__plugin_success_text_color__']              = 'Success style font color';
$lang['__plugin_success_text_hover_color__']        = 'Success style font color when cursor hovers over';
$lang['__plugin_success_background_color__']        = 'Success style background color';
$lang['__plugin_success_background_hover_color__']  = 'Success style background color when cursor hovers over';
$lang['__plugin_success_border_color__']            = 'Success style border color';
$lang['__plugin_success_border_hover_color__']      = 'Success style border color when cursor hovers over';
$lang['__plugin_success_light_text_color__']        = 'Success style font color for light box items';
$lang['__plugin_success_light_background_color__']  = 'Success style background color for light box items';
$lang['__plugin_success_light_border_color__']      = 'Success style border color for light box items';

$lang['__plugin_danger_text_color__']               = 'Danger style font color';
$lang['__plugin_danger_text_hover_color__']         = 'Danger style font color when cursor hovers over';
$lang['__plugin_danger_background_color__']         = 'Danger style background color';
$lang['__plugin_danger_background_hover_color__']   = 'Danger style background color when cursor hovers over';
$lang['__plugin_danger_border_color__']             = 'Danger style border color';
$lang['__plugin_danger_border_hover_color__']       = 'Danger style border color when cursor hovers over';
$lang['__plugin_danger_light_text_color__']         = 'Danger style font color for light box items';
$lang['__plugin_danger_light_background_color__']   = 'Danger style background color for light box items';
$lang['__plugin_danger_light_border_color__']       = 'Danger style border color for light box items';

$lang['__plugin_warning_text_color__']              = 'Warning style font color';
$lang['__plugin_warning_text_hover_color__']        = 'Warning style font color when cursor hovers over';
$lang['__plugin_warning_background_color__']        = 'Warning style background color';
$lang['__plugin_warning_background_hover_color__']  = 'Warning style background color when cursor hovers over';
$lang['__plugin_warning_border_color__']  =           'Warning style border color';
$lang['__plugin_warning_border_hover_color__']      = 'Warning style border color when cursor hovers over';
$lang['__plugin_warning_light_text_color__']        = 'Warning style font color for light box items';
$lang['__plugin_warning_light_background_color__']  = 'Warning style background color for light box items';
$lang['__plugin_warning_light_border_color__']      = 'Warning style border color for light box items';

$lang['__plugin_info_text_color__']                 = 'Info style font color';
$lang['__plugin_info_text_hover_color__']           = 'Info style font color when cursor hovers over';
$lang['__plugin_info_background_color__']           = 'Info style background color';
$lang['__plugin_info_background_hover_color__']     = 'Info style background color when cursor hovers over';
$lang['__plugin_info_border_color__']               = 'Info style border color';
$lang['__plugin_info_border_hover_color__']         = 'Info style border color when cursor hovers over';
$lang['__plugin_info_light_text_color__']           = 'Info style font color for light box items';
$lang['__plugin_info_light_background_color__']     = 'Info style background color for light box items';
$lang['__plugin_info_light_border_color__']         = 'Info style border color for light box items';

$lang['__plugin_light_text_color__']                = 'Light style font color';
$lang['__plugin_light_text_hover_color__']          = 'Light style font color when cursor hovers over';
$lang['__plugin_light_background_color__']          = 'Light style background color';
$lang['__plugin_light_background_hover_color__']    = 'Light style background color when cursor hovers over';
$lang['__plugin_light_border_color__']              = 'Light style border color';
$lang['__plugin_light_border_hover_color__']        = 'Light style border color when cursor hovers over';
$lang['__plugin_light_light_text_color__']          = 'Light style font color for light box items';
$lang['__plugin_light_light_background_color__']    = 'Light style background color for light box items';
$lang['__plugin_light_light_border_color__']        = 'Light style border color for light box items';

$lang['__plugin_dark_text_color__']                 = 'Dark style font color';
$lang['__plugin_dark_text_hover_color__']           = 'Dark style font color when cursor hovers over';
$lang['__plugin_dark_background_color__']           = 'Dark style background color';
$lang['__plugin_dark_background_hover_color__']     = 'Dark style background color when cursor hovers over';
$lang['__plugin_dark_border_color__']               = 'Dark style border color';
$lang['__plugin_dark_border_hover_color__']         = 'Dark style border color when cursor hovers over';
$lang['__plugin_dark_light_text_color__']           = 'Dark style font color for light box items';
$lang['__plugin_dark_light_background_color__']     = 'Dark style background color for light box items';
$lang['__plugin_dark_light_border_color__']         = 'Dark style border color for light box items';

$lang['__plugin_link_text_color__']                 = 'Link style font color';
$lang['__plugin_link_text_hover_color__']           = 'Link style font color when cursor hovers over';
$lang['__plugin_link_background_color__']           = 'Link style background color';
$lang['__plugin_link_background_hover_color__']     = 'Link style background color when cursor hovers over';
$lang['__plugin_link_border_color__']               = 'Link style border color';
$lang['__plugin_link_border_hover_color__']         = 'Link style border color when cursor hovers over';

$lang['__plugin_carousel_title_text_color__']           = 'Carousel title font color';
$lang['__plugin_carousel_caption_text_color__']         = 'Carousel caption font color';
$lang['__plugin_carousel_caption_background_color__']   = 'Carousel caption background color';
$lang['__plugin_carousel_control_fill_color__']         = 'Carousel control fill color';
$lang['__plugin_carousel_control_stroke_color__']       = 'Carousel control stroke color';
$lang['__plugin_carousel_indicator_color__']            = 'Carousel indicator color';

$lang['__plugin_steps_step_text_color__']                   = 'Steps font color';
$lang['__plugin_steps_border_color__']                      = 'Steps border color';
$lang['__plugin_steps_step_background_color__']             = 'Steps background color';
$lang['__plugin_steps_step_background_complete_color__']    = 'Steps background color for completed steps';

$lang['__plugin_tabgroup_tab_text_active_color__']          = 'Tabgroup active tab font color';
$lang['__plugin_tabgroup_tab_background_active_color__']    = 'Tabgroup active tab background color';
$lang['__plugin_tabgroup_tab_border_hover_color__']         = 'Tabgroup inactive tab border color when cursor hovers
over';

$lang['__plugin_tooltip_text_color__']          = 'Tooltip font color';
$lang['__plugin_tooltip_background_color__']    = 'Tooltip background color';
$lang['__plugin_tooltip_border_color__']        = 'Tooltip border color';

/* Add darkmode language */
$lang['__darkmode_text__']          = 'Main text color';
$lang['__darkmode_background__']    = 'Main background color';

foreach ($lang as $key => $val) {
    if (strpos($key, '_darkmode_') === false) {
        if (substr($key, 0, 9) === '__plugin_') {
            $lang['__plugin_darkmode_' . substr($key, 9)] = $val;
        } else {
            $lang['__darkmode_' . substr($key, 2)] = $val;
        }
    }
}
