# DokuWiki Template Ad-Hominem

A clean and lightweight HTML5 template for [DokuWiki](https://github.com/dokuwiki/dokuwiki).

## Features


  * Prominent search field with preloading search results.
  * Collapsible sidebar and table of contents.
  * Link preview: title and first paragraph of the linked page is shown in the title text.
    * This also works for Wikipedia links!
  * Looks good in print.
  * The template implements [WCAG 2.1](https://www.w3.org/TR/WCAG21/) Level AA (however, the DokuWiki content renderer has some limitations)
  * [GDPR](https://en.wikipedia.org/wiki/General_Data_Protection_Regulation)-compliant: does not load external resources like font files or others (note that the [jquerycdn](https://www.dokuwiki.org/config:jquerycdn) setting needs to be set to “local delivery only” for GDPR-compliance)
  * Neatly formatted and standards-compliant code (where possible – again, the DokuWiki content renderer is the limiting factor)
  * Makes better use of larger screens (target is half of a 4K screen), but because the template is fully responsive, smaller is no problem (down to ca. 300px wide)
  * improvements to edit view, media manager, etc.
  * User-side controlled “dark mode”, i.e. follows the client side dark mode settings.
  * Improvements to the default functionality, e.g. a resizeable internal link selection widget, etc.
  * Configuration to override the "home"-link (see below)
  * Integrated "Cookies" banner functionality
  * Integrated languages menu (works with the [Translate](https://www.dokuwiki.org/plugin:translate) plugin)
  * Compatible with PHP8+ as well as DokuWiki “[Kaos](https://www.dokuwiki.org/changes#release_2024-02-06_kaos)”.
  * Support for global RTL (right-to-left) site direction.

## Localizations

As the template uses only the original DokuWiki template strings, it should work with any of the languages that DokuWiki comes in.
  
## More information

Please see the [Plugin page on the DokuWiki site](https://www.dokuwiki.org/template:ad-hominem) for more information: 
