<?php

/**
 * DokuWiki Mikio Template Chinese Simplified Language File
 *
 * @link    http://dokuwiki.org/template:mikio
 * @author  Little-Data <https://github.com/Little-Data>
 * @license GPLv2 (http://www.gnu.org/licenses/gpl-2.0.html)
 */

 /* Theme */
$lang['sidebar-title']  = '侧边栏';
$lang['tools-menu']     = '工具菜单';
$lang['home']           = '首页';


/* Config */
$lang['config_navbar']      = '菜单栏';
$lang['config_search']      = '搜索';
$lang['config_hero']        = '顶部大标题';
$lang['config_tags']        = '标签';
$lang['config_breadcrumb']  = '页面踪迹';
$lang['config_youarehere']  = '您在这里';
$lang['config_sidebar']     = '侧边栏';
$lang['config_toc']         = '文章目录';
$lang['config_pagetools']   = '页面工具';
$lang['config_footer']      = '页脚';
$lang['config_license']     = '许可';
$lang['config_acl']         = '权限';
$lang['config_sticky']      = '粘性部件';

/* Setting Values */
$lang['value_never']        = '从不';
$lang['value_admin']        = '管理员';
$lang['value_always']       = '总是';
$lang['value_icons']        = '图标';
$lang['value_text']         = '文本';
$lang['value_both']         = '两个都要';
$lang['value_separate']     = '分离式';
$lang['value_dropdown']     = '下拉式';
$lang['value_combine']      = '组合';
$lang['value_none']         = '无';
$lang['value_custom']       = '自定义';
$lang['value_search']       = '搜索';
$lang['value_dokuwiki']     = 'dokuwiki';
$lang['value_logged_in']    = '已登录';
$lang['value_logged_out']   = '已退出登录';
$lang['value_icon']         = '图标';
$lang['value_top']          = '顶部';
$lang['value_hero']         = '顶部大标题';
$lang['value_page']         = '页面';
$lang['value_page_title']   = '页面标题';
$lang['value_home']         = '首页';
$lang['value_logged_in_user'] = '登录的用户';
$lang['value_content']      = '内容';
$lang['value_tags']         = '标签';
$lang['value_page_editors'] = '页面编辑者';
$lang['value_badge']        = '徽章';
$lang['value_button']       = '按钮';

/* Style.ini */
$lang['__link__']       = '链接文字颜色';
$lang['__link_hover__'] = '光标悬停在链接上时文字颜色';
$lang['__link_visited__'] = '已浏览链接文字颜色';
$lang['__link_active__'] = '链接被点击时文字颜色';
$lang['__existing__']   = '指向现有维基页面链接文字颜色';
$lang['__existing_hover__']   = '光标悬停在现有维基页面上时链接文字颜色';
$lang['__existing_visited__']   = '已访问的维基页面链接文字颜色';
$lang['__existing_active__']   = '现有维基页面被点击时链接文字颜色';
$lang['__missing__']    = '缺失的维基页面链接文字颜色';
$lang['__missing_hover__']    = '光标悬停在缺失的维基页面上时链接文字颜色';
$lang['__missing_visited__']    = '已访问缺失的维基页面链接文字颜色';
$lang['__missing_active__']    = '缺失的维基页面被点击时链接文字颜色';
$lang['__line_height__']    = '基本字体行高';
$lang['__site_width__']     = '正文内容宽度';

$lang['__font_size__']              = '基本字号';
$lang['__font_family__']            = '基本字体集（包含空格的字体必须使用引号。多个字体可以用逗号隔开）';
$lang['__admin_background_color__'] = '管理页面背景颜色';

$lang['__code_font_family__']       = '代码块字体集（包含空格的字体必须加引号。可使用逗号分隔多种字体）';
$lang['__code_font_size__']         = '代码块字体大小';
$lang['__code_text_color__']        = '代码块字体颜色';
$lang['__code_background_color__']  = '代码块背景颜色';
$lang['__code_line_height__']       = '代码块字体行高';
$lang['__code_word_wrap__']         = '代码块换行样式';
$lang['__code_border_color__']      = '代码块边框颜色';

$lang['__control_text_color__']                     = '控件字体颜色';
$lang['__control_border_color__']                   = '控件边框颜色';
$lang['__control_background_color__']               = '控件背景颜色';
$lang['__button_text_color__']                      = '按钮字体颜色';
$lang['__button_background_color__']                = '按钮背景颜色';
$lang['__button_border_color__']                    = '按钮边框颜色';
$lang['__button_text_hover_color__']                = '光标悬停时按钮字体颜色';
$lang['__button_background_hover_color__']          = '光标悬停时按钮的背景颜色';
$lang['__button_border_hover_color__']              = '光标悬停时按钮的边框颜色';
$lang['__input_border_color__']                     = '控件的边框颜色';
$lang['__button_default_text_color__']              = '默认按钮的字体颜色';
$lang['__button_default_background_color__']        = '默认按钮的背景颜色';
$lang['__button_default_border_color__']            = '默认按钮的边框颜色';
$lang['__button_default_text_hover_color__']        = '光标悬停在默认按钮上时的字体颜色';
$lang['__button_default_background_hover_color__']  = '光标悬停时默认按钮的背景颜色';
$lang['__button_default_border_hover_color__']      = '光标悬停时默认按钮的边框颜色';
$lang['__button_search_text_color__']               = '搜索按钮的字体颜色';
$lang['__button_search_background_color__']         = '搜索按钮的背景颜色';
$lang['__button_search_border_color__']             = '搜索按钮的边框颜色';
$lang['__button_search_text_hover_color__']         = '光标悬停在搜索按钮上时的字体颜色';
$lang['__button_search_background_hover_color__']   = '光标悬停在搜索按钮上时搜索按钮的背景颜色';
$lang['__button_search_border_hover_color__']       = '光标悬停在搜索按钮上时的边框颜色';

$lang['__topheader_background_color__'] = '标题顶部的背景颜色';
$lang['__header_background_color__']    = '标题部分的背景颜色';

$lang['__navbar_background_color__']    = '菜单的背景颜色';
$lang['__navbar_border_color__']        = '菜单的边框颜色';
$lang['__navbar_brand_text_color__']    = '网站标题的字体颜色';
$lang['__navbar_brand_tagline_color__'] = '网站标语的字体颜色';
$lang['__navbar_content_justify__']     = '网站菜单内容的排布（可以是 flex-start、flex-end、center、space-bween 或 space-around、space-between、space-around）';
$lang['__navbar_link_color__']          = '导航栏链接的字体颜色';
$lang['__navbar_link_hover_color__']    = '光标悬停在导航栏链接上时的字体颜色';

$lang['__subnavbar_text_color__']       = '子菜单文本的字体颜色';
$lang['__subnavbar_link_color__']       = '子菜单链接的字体颜色';
$lang['__subnavbar_link_hover_color__'] = '光标悬停在子菜单链接上时的字体颜色';
$lang['__subnavbar_background_color__'] = '子菜单的背景颜色';
$lang['__subnavbar_border_color__']     = '子菜单的边框颜色';
$lang['__subnavbar_content_justify__']  = '子菜单内容的排布（可以是 flex-start、flex-end、center、space-bween 或 space-around、space-between、space-around）';

$lang['__tag_background_color__']   = '标签的背景颜色';
$lang['__tag_text_color__']         = '标签的字体颜色';

$lang['__breadcrumb_background_color__']    = '页面踪迹的背景颜色';
$lang['__breadcrumb_font_size__']           = '页面踪迹的字体大小';
$lang['__breadcrumb_text_color__']          = '页面踪迹文本颜色';
$lang['__breadcrumb_link_color__']          = '页面踪迹链接的字体颜色';
$lang['__breadcrumb_link_hover_color__']    = '光标停留在页面踪迹链接上时的字体颜色';

$lang['__hero_title_color__']       = '顶部大标题的字体颜色';
$lang['__hero_subtitle_color__']    = '顶部大标题下副标题的字体颜色';
$lang['__hero_background_color__']  = '顶部大标题块的背景颜色';

$lang['__sidebar_width__']              = '侧边栏宽度';
$lang['__sidebar_font_size__']          = '侧边栏字体大小';
$lang['__sidebar_text_color__']         = '侧边栏文字颜色';
$lang['__sidebar_link_color__']         = '侧边栏链接颜色';
$lang['__sidebar_link_hover_color__']   = '光标悬停在侧边栏链接上时的字体颜色';
$lang['__sidebar_background_color__']   = '侧边栏的背景颜色';
$lang['__sidebar_border_color__']       = '侧边栏的边框颜色';

$lang['__content_background__'] = '页面内容的背景颜色';

$lang['__toc_background_color__']   = '页面目录的背景颜色';
$lang['__toc_border_color__']       = '页面目录的边框颜色';
$lang['__toc_font_size__']          = '页面目录字体大小';
$lang['__toc_link_color__']         = '页面目录链接的字体颜色';
$lang['__toc_link_hover_color__']   = '当光标停留在页面目录链接上时的字体颜色';

$lang['__pagetools_color__']        = '页面工具图标的颜色';
$lang['__pagetools_hover_color__']  = '光标悬停时页面工具图标的颜色';

$lang['__footer_font_size__']           = '页脚字体大小';
$lang['__footer_text_color__']          = '页脚的字体颜色';
$lang['__footer_link_color__']          = '页脚链接的字体颜色';
$lang['__footer_link_hover_color__']    = '光标停留在页脚链接上时的字体颜色';
$lang['__footer_text_align__']          = '页脚文本的对齐方式（可以是左、居中、右或对齐）';
$lang['__footer_background_color__']    = '页脚的背景颜色';

$lang['__table_font_size__']                    = '表格的字体大小';
$lang['__table_row_border_color__']             = '表格的行边框颜色';
$lang['__table_col_border_color__']             = '表格的列边框颜色';
$lang['__table_header_row_background_color__']  = '表格标题行的背景颜色';
$lang['__table_header_row_text_color__']        = '表格标题行的字体颜色';
$lang['__table_odd_row_text_color__']           = '表格奇数行的字体颜色';
$lang['__table_odd_row_background_color__']     = '表格奇数行的背景颜色';
$lang['__table_even_row_text_color__']          = '表格偶数行的字体颜色';
$lang['__table_even_row_background_color__']    = '表格偶数行的背景颜色';
$lang['__table_horizontal_padding__']           = '表格单元格的水平填充';
$lang['__table_vertical_padding__']             = '表格单元格的垂直填充';

$lang['__dropdown_color__']             = '下拉菜单的字体颜色';
$lang['__dropdown_hover_color__']       = '光标停留在下拉菜单项目上时的字体颜色';
$lang['__dropdown_border_color__']      = '下拉菜单的边框颜色';
$lang['__dropdown_background_color__']  = '下拉菜单的背景颜色';

$lang['__section_edit_highlight__']     = '高亮显示编辑区时的颜色';

$lang['__tree_background_color__']  = '树形视图的背景颜色';
$lang['__tree_border_color__']      = '树形视图的边框颜色';

$lang['__tab_color__']                      = '选项卡的字体颜色';
$lang['__tab_background_color__']           = '标签页的背景颜色';
$lang['__tab_border_color__']               = '标签页的边框颜色';
$lang['__tab_hover_color__']                = '光标悬停时标签页的字体颜色';
$lang['__tab_background_hover_color__']     = '光标悬停时标签页的背景颜色';
$lang['__tab_border_hover_color__']         = '光标悬停时标签页的边框颜色';
$lang['__tab_active_color__']               = '活动选项卡的字体颜色';
$lang['__tab_active_background_color__']    = '活动选项卡的背景颜色';
$lang['__tab_active_border_color__']        = '活动选项卡的边框颜色';

/* Plugin */
$lang['__plugin_background_color__']        = 'Mikio 插件元素的背景颜色';
$lang['__plugin_border_color__']            = 'Mikio 插件元素上使用的边框颜色';
$lang['__plugin_header_background_color__'] = 'Mikio 插件元素中标题项目使用的背景颜色';
$lang['__plugin_footer_background_color__'] = 'Mikio 插件元素中页脚项目使用的背景颜色';

$lang['__plugin_primary_text_color__']              = '主风格字体颜色';
$lang['__plugin_primary_text_hover_color__']        = '光标悬停在字体上时主要字体颜色';
$lang['__plugin_primary_background_color__']        = '主风格背景颜色';
$lang['__plugin_primary_background_hover_color__']  = '光标悬停在字体上时主要背景颜色';
$lang['__plugin_primary_border_color__']            = '主风格边框颜色';
$lang['__plugin_primary_border_hover_color__']      = '光标悬停在字体上时主要边框颜色';
$lang['__plugin_primary_light_text_color__']        = '灯箱项目的主要样式字体颜色';
$lang['__plugin_primary_light_background_color__']  = '灯箱项目的主要样式背景色';
$lang['__plugin_primary_light_border_color__']      = '灯箱项目的主样式边框颜色';

$lang['__plugin_secondary_text_color__']                = '次要风格字体颜色';
$lang['__plugin_secondary_text_hover_color__']          = '光标悬停在字体上时次要字体颜色';
$lang['__plugin_secondary_background_color__']          = '次要风格背景颜色';
$lang['__plugin_secondary_background_hover_color__']  = '光标悬停在字体上时次要背景颜色';
$lang['__plugin_secondary_border_color__']              = '次要风格边框颜色';
$lang['__plugin_secondary_border_hover_color__']        = '光标悬停时的次要边框颜色';
$lang['__plugin_secondary_light_text_color__']          = '灯箱项目的次要字体颜色';
$lang['__plugin_secondary_light_background_color__']  = '灯箱项目的次要背景色';
$lang['__plugin_secondary_light_border_color__']        = '灯箱项目的次要边框颜色';

$lang['__plugin_success_text_color__']              = '成功样式字体颜色';
$lang['__plugin_success_text_hover_color__']        = '光标悬停时成功样式字体的颜色';
$lang['__plugin_success_background_color__']        = '成功样式背景颜色';
$lang['__plugin_success_background_hover_color__']  = '光标悬停时的成功样式背景颜色';
$lang['__plugin_success_border_color__']            = '成功样式边框颜色';
$lang['__plugin_success_border_hover_color__']      = '光标悬停时的成功样式边框颜色';
$lang['__plugin_success_light_text_color__']        = '灯箱项目的成功样式字体颜色';
$lang['__plugin_success_light_background_color__']  = '灯箱项目的成功样式背景颜色';
$lang['__plugin_success_light_border_color__']      = '灯箱项目的成功样式边框颜色';

$lang['__plugin_danger_text_color__']               = '危险样式字体颜色';
$lang['__plugin_danger_text_hover_color__']         = '光标悬停时的危险样式字体颜色';
$lang['__plugin_danger_background_color__']         = '危险样式背景颜色';
$lang['__plugin_danger_background_hover_color__']   = '光标悬停时的危险样式背景颜色';
$lang['__plugin_danger_border_color__']             = '危险样式边框颜色';
$lang['__plugin_danger_border_hover_color__']       = '光标悬停时的危险样式边框颜色';
$lang['__plugin_danger_light_text_color__']         = '灯箱项目的危险样式字体颜色';
$lang['__plugin_danger_light_background_color__']   = '灯箱项目的危险样式背景颜色';
$lang['__plugin_danger_light_border_color__']       = '灯箱项目的危险样式边框颜色';

$lang['__plugin_warning_text_color__']              = '警告样式字体颜色';
$lang['__plugin_warning_text_hover_color__']        = '光标悬停时警告样式字体颜色';
$lang['__plugin_warning_background_color__']        = '警告样式背景颜色';
$lang['__plugin_warning_background_hover_color__']  = '光标悬停时的警告样式背景颜色';
$lang['__plugin_warning_border_color__']            = '警告样式边框颜色';
$lang['__plugin_warning_border_hover_color__']      = '光标悬停时的警告样式边框颜色';
$lang['__plugin_warning_light_text_color__']        = '灯箱项目的警告样式字体颜色';
$lang['__plugin_warning_light_background_color__']  = '灯箱项目的警告样式背景颜色';
$lang['__plugin_warning_light_border_color__']      = '灯箱项目的警告样式边框颜色';

$lang['__plugin_info_text_color__']                 = '信息样式字体颜色';
$lang['__plugin_info_text_hover_color__']           = '光标悬停时信息样式字体的颜色';
$lang['__plugin_info_background_color__']           = '信息样式背景颜色';
$lang['__plugin_info_background_hover_color__']     = '光标悬停时的信息样式背景颜色';
$lang['__plugin_info_border_color__']               = '信息样式边框颜色';
$lang['__plugin_info_border_hover_color__']         = '光标悬停时的信息样式边框颜色';
$lang['__plugin_info_light_text_color__']           = '灯箱项目的信息样式字体颜色';
$lang['__plugin_info_light_background_color__']     = '灯箱项目的信息样式背景颜色';
$lang['__plugin_info_light_border_color__']         = '灯箱项目的信息样式边框颜色';

$lang['__plugin_light_text_color__']                = '浅色模式字体颜色';
$lang['__plugin_light_text_hover_color__']          = '光标悬停时浅色模式字体颜色';
$lang['__plugin_light_background_color__']          = '浅色模式背景颜色';
$lang['__plugin_light_background_hover_color__']    = '光标悬停时浅色模式背景颜色';
$lang['__plugin_light_border_color__']              = '浅色模式边框颜色';
$lang['__plugin_light_border_hover_color__']        = '光标悬停时浅色模式边框颜色';
$lang['__plugin_light_light_text_color__']          = '浅色模式灯箱项目字体颜色';
$lang['__plugin_light_light_background_color__']    = '浅色模式灯箱项目背景颜色';
$lang['__plugin_light_light_border_color__']        = '浅色模式灯箱项目边框颜色';

$lang['__plugin_dark_text_color__']                 = '深色模式字体颜色';
$lang['__plugin_dark_text_hover_color__']           = '光标悬停时深色模式字体颜色';
$lang['__plugin_dark_background_color__']           = '深色模式背景颜色';
$lang['__plugin_dark_background_hover_color__']     = '光标悬停时深色模式背景颜色';
$lang['__plugin_dark_border_color__']               = '深色模式边框颜色';
$lang['__plugin_dark_border_hover_color__']         = '光标悬停时深色模式边框颜色';
$lang['__plugin_dark_light_text_color__']           = '深色模式灯箱项目字体颜色';
$lang['__plugin_dark_light_background_color__']     = '深色模式灯箱项目背景颜色';
$lang['__plugin_dark_light_border_color__']         = '深色模式灯箱项目边框颜色';

$lang['__plugin_link_text_color__']                 = '链接样式字体颜色';
$lang['__plugin_link_text_hover_color__']           = '光标悬停时链接样式字体颜色';
$lang['__plugin_link_background_color__']           = '链接样式背景颜色';
$lang['__plugin_link_background_hover_color__']     = '光标悬停时链接样式背景颜色';
$lang['__plugin_link_border_color__']               = '链接样式边框颜色';
$lang['__plugin_link_border_hover_color__']         = '光标悬停时链接样式边框颜色';

$lang['__plugin_carousel_title_text_color__']           = '轮播框标题字体颜色';
$lang['__plugin_carousel_caption_text_color__']         = '轮播框说明文字颜色';
$lang['__plugin_carousel_caption_background_color__']   = '轮播框说明文字背景颜色';
$lang['__plugin_carousel_control_fill_color__']         = '轮播框翻页控件填充颜色';
$lang['__plugin_carousel_control_stroke_color__']       = '轮播框翻页控件描边颜色';
$lang['__plugin_carousel_indicator_color__']            = '轮播框指示器颜色';

$lang['__plugin_steps_step_text_color__']                   = '步骤字体颜色';
$lang['__plugin_steps_border_color__']                      = '步骤边框颜色';
$lang['__plugin_steps_step_background_color__']             = '步骤背景颜色';
$lang['__plugin_steps_step_background_complete_color__']    = '已完成步骤的背景颜色';

$lang['__plugin_tabgroup_tab_text_active_color__']          = '选项卡组活动选项卡字体颜色';
$lang['__plugin_tabgroup_tab_background_active_color__']    = '选项卡组活动选项卡背景颜色';
$lang['__plugin_tabgroup_tab_border_hover_color__']         = '光标悬停时选项卡组非活动选项卡边框颜色';

$lang['__plugin_tooltip_text_color__']          = '工具提示字体颜色';
$lang['__plugin_tooltip_background_color__']    = '工具提示背景颜色';
$lang['__plugin_tooltip_border_color__']        = '工具提示边框颜色';

/* Add darkmode language */
$lang['__darkmode_text__']          = '深色模式主文字颜色';
$lang['__darkmode_background__']    = '深色模式主背景色';

foreach ($lang as $key => $val) {
    if (strpos($key, '_darkmode_') === false) {
        if (substr($key, 0, 9) === '__plugin_') {
            $lang['__plugin_darkmode_' . substr($key, 9)] = $val;
        } else {
            $lang['__darkmode_' . substr($key, 2)] = $val;
        }
    }
}
